'use strict';_={_:" Saves the content of one or more <c h=/url>URLs</c>, each to its own <br> file under any desired folder. <br>\n The saved files can then be opened automatically or be <br> passed to any program or command.\n ",url:" The URL may contain <c h=/plcHld>placeholders</c> such as <c mnsp hl0>&lt;clipboard&gt;</c>, <c mnsp hl0>&lt;omnibox&gt;</c>, etc. <hr b=2> \n In order to save the URL of the element under the mouse pointer (link, image, video, <br> etc.), you can use the \n <act inln xsml>Save Element URL</act> basic action or, if you need advanced <br> configurations,\n you can use the following <c h=/actions/actChain>action chain</c>: <hr b=3>\n <center><mid><act>Copy hovered URL</act> <sep></sep> <act>Save URL</act></mid></center>\n <hr b=3>\n and use the <c mnsp hl0>&lt;<c h=/actions/tmplExpr/clbrd>clipboard</c>&gt;</c> placeholder in the URL field.\n <{MORE}> <hr b=2>\n There are two ways you can specify multiple URLs to be saved: <hr b=2>\n <b>First:</b> <br>\n By using a placeholder that refers to the action's <c h=/actions/tgtTabs>target tabs</c>, such as the\n <c mnsp hl0>&lt;url&gt;</c> <br> placeholder. Then, you have to specify multiple tabs in the <b u>Apply to:</b> select box. <br>\n That way the action will repeat itself for each of those tabs and the placeholder <br> will give the corresponding URL each time.\n <hr b=2>\n <b>Second:</b> <br>\n By using a placeholder that gives a list of elements, such as <c mnsp hl0>&lt;<c h=/actions/tmplExpr/clbLns>clipboard.lines</c>&gt;</c>. <br>\n The action will repeat itself for each element given by the placeholder.\n ",
dir:` <c h=/fsPath>Absolute path</c> to the folder where the URL will be saved. If omitted, a <br> "Save as" dialog box will appear when the action is executed. <hr b>\n If the folder path doesn't exist, it will be created. <hr b>\n The path may contain <c h=/plcHld>placeholders</c> such as <c mnsp hl0>&lt;domain&gt;</c>, <c mnsp hl0>&lt;path&gt;</c>, etc.\n <{MORE}><hr b=3>\n If you choose <c blu>"Dwnld manager"</c> in the <u blr blk>Method</u> field, the behavior <br> changes as follows: <hr b=2>\n <it></it><c ib>The folder path has to be <c h=/fsPath>relative</c> to the browser's <a dimLnk href="${_Fu("dwldLoc")}">downloads folder</a>. <br>\n If it's absolute, it will be ignored.</c> <hr b=2>\n <it></it><c ib>If omitted, the browser's downloads folder will be used.</c> <hr b>\n <it></it><c ib>If you check the option <a dimLnk href="${_Fu("ask where")}">Ask where to save before downloading</a> in your <br>\n browser settings, the "Save as" dialog box will always show up.</c>\n <hr b=3>\n For example, if the browser's downloads folder is <c hl0>C:\\Downloads</c>, and you <br> enter <c hl0>Photos\\Vacation</c> in this field,\n the file will be saved to: <hr b=2>\n <center><c hl0>C:\\Downloads\\Photos\\Vacation</c></center>\n `,
fnm:` The file will be saved with the name that comes in the URL itself, <br> unless you specify a custom filename here. <br>\n It can contain <c h=/plcHld>placeholders</c> such as <c mnsp hl0>&lt;fileName&gt;</c>, <c mnsp hl0>&lt;fileExt&gt;</c>, etc. <hr b=2>\n \n For example, if the URL is: <hr b>\n <c mnsp hl>http://example.com/antarctica/<c red>glaciers</c><c grn>.jpg</c></c> <hr b=2>\n And you enter the following in this field: <hr b>\n <c mnsp hl>[<c red>&lt;fileName&gt;</c>] <c blu>&lt;date&gt;</c><c grn>&lt;fileExt&gt;</c></c>  <hr b=2>\n The resulting filename will be: <hr b>\n <c mnsp hl>[<c red>glaciers</c>] <c blu>${_ql(new Date)}</c><c grn>.jpg</c></c>\n `,
sil:" The URL will be downloaded and saved without any visual <br> or audible cue. <br>\n On success, the file will just appear in the destination folder. <br> On failure, nothing will happen.\n ",aud:' A success sound will be played once the URL has been saved. <br> Or a failure sound if the operation fails. <br>\n These two sounds correspond to the "Asterisk" and "Critical stop" <br> system sounds on the Windows control panel.\n ',ntf:" A floating display will appear near the <c h=/sysTr>notification area</c> <br> showing the URL being saved, its size,\n destination path, <br> and download progress.\n ",
mgr0:` The URL will be added to the browser's download bar and <a dimLink href="chrome://downloads/">downloads page</a>, <br>\n as all manual downloads are. <hr b=2>\n This method has the following limitations: <hr b>\n <it></it><c ib>The destination folder can only be the browser's <a dimLnk href="${_Fu("dwldLoc")}">downloads folder</a> <br>\n or a subfolder inside it.</c> <hr b=2>\n <it></it><c ib>The "Save as" dialog box will always show up if you check the option <br>\n <a dimLnk href="${_Fu("ask where")}">Ask where to save before downloading</a> in your browser settings.</c> <hr b=2>\n <it></it><c ib>The browser cache is not always used, so the download may take <br> significantly longer for large files.</c> \n `,
mgr:" <{mgr0}> <hr b=2>\n <it></it><c ib>The <u blr blk>If file exists:</u> setting is not supported.</c>\n ",svas:' This will force the "Save as" dialog box to always <br> be shown regardless of any other settings.\n ',ifEx:' <hr b=2>\n <b>Rename:</b> A number will be appended to the filename to make it unique. <br>\n <b>Overwrite:</b> The existing file will be overwritten. <br>\n <b>Ask:</b> A "Save as" dialog box will ask what to do. <br>\n <b>Cancel:</b> The download will be canceled and nothing will be saved.\n ',
flEx:" What to do if an identical file already exists in the destination folder. <br>\n Two files are considered identical if they have the same name, size and <br> modified date.\n <{ifEx}>\n ",nmEx:' What to do if a different file with the same name already exists in the <br> destination folder.\n Two files are different if they don\'t have the exact <br> same size and modified date. <br>\n If you choose <c blu>"Dwnld manager"</c> in the <u blr blk>Method:</u> select box, this setting <br> will apply even if the existing file is identical.\n <{ifEx}>\n ',
end:" What to do when the URL has been successfully saved. <hr b>\n <b>Open file:</b> The file or files will be opened with the <br> default program for their file type. <hr b=2>\n <b>Show in folder:</b> The destination folder will be opened. <hr b=2>\n <b>Copy file path:</b> The full path of the files will be copied <br> to the clipboard (one path <c h=/actions/txtLn>per line</c>).\n Those paths can <br> then be passed to an external program or command <br> by using the <act inln xsml>Open file/program</act> action.\n "};
